/*
 * Decompiled with CFR 0.152.
 */
package org.jumpmind.symmetric.wrapper;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileReader;
import java.io.FilenameFilter;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class WrapperConfig {
    protected String configFile;
    protected Map<String, ArrayList<String>> prop;
    protected File workingDirectory;
    protected String jarFile;

    public WrapperConfig(String applHomeDir, String configFile, String jarFile) throws IOException {
        this.prop = this.getProperties(configFile);
        this.configFile = new File(configFile).getAbsolutePath();
        this.jarFile = new File(jarFile).getAbsolutePath();
        this.workingDirectory = new File(applHomeDir);
    }

    public String getWrapperJarPath() {
        return this.jarFile;
    }

    public String getConfigFile() {
        return this.configFile;
    }

    public File getWorkingDirectory() {
        return this.workingDirectory;
    }

    public String getLogFile() {
        return this.getProperty(this.prop, "wrapper.logfile", "logs/wrapper.log");
    }

    public String getWrapperPidFile() {
        return this.getProperty(this.prop, "wrapper.pidfile", "tmp/wrapper.pid");
    }

    public String getServerPidFile() {
        return this.getProperty(this.prop, "wrapper.server.pidfile", "tmp/server.pid");
    }

    public long getLogFileMaxSize() {
        String str = this.getProperty(this.prop, "wrapper.logfile.maxsize", "10M").toUpperCase();
        int multiplier = 1;
        if (str.indexOf("K") != -1) {
            multiplier = 1024;
        } else if (str.indexOf("M") != -1) {
            multiplier = 0x100000;
        }
        return Long.parseLong(str.replaceAll("[^0-9]", "")) * (long)multiplier;
    }

    public int getLogFileMaxFiles() {
        return Integer.parseInt(this.getProperty(this.prop, "wrapper.logfile.maxfiles", "3"));
    }

    public String getLogFileLogLevel() {
        return this.getProperty(this.prop, "wrapper.logfile.loglevel", "INFO");
    }

    public String getName() {
        return this.getProperty(this.prop, "wrapper.name", "symmetricds");
    }

    public String getDisplayName() {
        return this.getProperty(this.prop, "wrapper.displayname", "SymmetricDS");
    }

    public String getDescription() {
        return this.getProperty(this.prop, "wrapper.description", "SymmetricDS Database Synchronization");
    }

    public boolean isAutoStart() {
        return this.getProperty(this.prop, "wrapper.ntservice.starttype", "auto").equalsIgnoreCase("auto");
    }

    public boolean isDelayStart() {
        return this.getProperty(this.prop, "wrapper.ntservice.starttype", "auto").equalsIgnoreCase("delay");
    }

    public String getFailureActionCommand() {
        return this.getProperty(this.prop, "wrapper.ntservice.failure.action.command", "");
    }

    public int getFailureResetPeriod() {
        return Integer.parseInt(this.getProperty(this.prop, "wrapper.ntservice.failure.reset.period", "300"));
    }

    public List<FailureAction> getFailureActions() {
        List<String> types = this.getListProperty(this.prop, "wrapper.ntservice.failure.action.type");
        List<String> delays = this.getListProperty(this.prop, "wrapper.ntservice.failure.action.delay");
        int count = types.size() >= 3 ? 3 : types.size();
        ArrayList<FailureAction> actions = new ArrayList<FailureAction>(count);
        int i = 0;
        for (String type : types) {
            String delay = "0";
            if (i < delays.size()) {
                delay = delays.get(i);
            }
            actions.add(new FailureAction(type, delay));
            ++i;
        }
        return actions;
    }

    public List<String> getDependencies() {
        return this.prop.get("wrapper.ntservice.dependency");
    }

    public String getJavaCommand() {
        Object javaCmd = this.getProperty(this.prop, "wrapper.java.command", "java");
        if (((String)javaCmd).toLowerCase().endsWith("service.exe")) {
            javaCmd = System.getProperty("java.home") + File.separator + "bin" + File.separator + "javaw.exe";
        }
        return javaCmd;
    }

    public String getServiceCommand() {
        return this.getProperty(this.prop, "wrapper.java.command", "java");
    }

    public List<String> getOptions() {
        return this.prop.get("wrapper.java.additional");
    }

    public String getRunAsUser() {
        return this.getProperty(this.prop, "wrapper.run.as.user", "");
    }

    public String getRunAsPassword() {
        return this.getProperty(this.prop, "wrapper.run.as.password", "");
    }

    public List<String> getApplicationParameters() {
        return this.getListProperty(this.prop, "wrapper.app.parameter");
    }

    public String getApplicationOutputStart() {
        return this.getProperty(this.prop, "wrapper.app.output.start", "");
    }

    public String getApplicationOutputRestart() {
        return this.getProperty(this.prop, "wrapper.app.output.restart", "");
    }

    public String getMaxMemory() {
        return this.getProperty(this.prop, "wrapper.java.maxmemory", "256");
    }

    public ArrayList<String> getCommand(boolean isConsole) {
        ArrayList<String> cmdList = new ArrayList<String>();
        cmdList.add(this.getJavaCommand());
        Object initMem = this.getProperty(this.prop, "wrapper.java.initmemory", "256");
        if (!((String)initMem).toUpperCase().endsWith("M")) {
            initMem = (String)initMem + "M";
        }
        cmdList.add("-Xms" + (String)initMem);
        Object maxMem = this.getProperty(this.prop, "wrapper.java.maxmemory", "256");
        if (!((String)maxMem).toUpperCase().endsWith("M")) {
            maxMem = (String)maxMem + "M";
        }
        cmdList.add("-Xmx" + (String)maxMem);
        cmdList.add("-cp");
        cmdList.add(this.getClassPath());
        List<String> javaAdditional = this.getListProperty(this.prop, "wrapper.java.additional");
        cmdList.addAll(javaAdditional);
        List<String> appParams = this.getListProperty(this.prop, "wrapper.app.parameter");
        appParams.remove("--no-log-console");
        cmdList.addAll(appParams);
        if (!isConsole) {
            cmdList.add("--no-log-console");
        }
        return cmdList;
    }

    public String getClassPath() {
        String version = System.getProperty("java.version");
        boolean expandWildcard = version != null && version.startsWith("1.5");
        List<String> cp = this.getListProperty(this.prop, "wrapper.java.classpath");
        StringBuilder sb = new StringBuilder(cp.size());
        for (int i = 0; i < cp.size(); ++i) {
            if (i > 0) {
                sb.append(File.pathSeparator);
            }
            String classPath = cp.get(i);
            classPath = expandWildcard ? this.expandWildcard(classPath) : classPath.replaceAll("\\*\\.jar", "*");
            sb.append(classPath);
        }
        return sb.toString();
    }

    private String expandWildcard(String classPath) {
        int index = classPath.indexOf("*");
        if (index != -1) {
            String dirName = classPath.substring(0, index);
            File dir = new File(dirName);
            File[] files = dir.listFiles(new FilenameFilter(){

                @Override
                public boolean accept(File dir, String name) {
                    return name.endsWith(".jar") || name.endsWith(".JAR");
                }
            });
            StringBuilder sb = new StringBuilder();
            if (files != null) {
                for (int i = 0; i < files.length; ++i) {
                    if (i > 0) {
                        sb.append(File.pathSeparator);
                    }
                    sb.append(dirName).append(files[i].getName());
                }
            }
            classPath = sb.toString();
        }
        return classPath;
    }

    private Map<String, ArrayList<String>> getProperties(String filename) throws IOException {
        HashMap<String, ArrayList<String>> map = new HashMap<String, ArrayList<String>>();
        BufferedReader reader = new BufferedReader(new FileReader(filename));
        String line = null;
        while ((line = reader.readLine()) != null) {
            ArrayList<String> values;
            int index;
            if (line.matches("^\\s*#.*") || line.matches("\\s*") || (index = line.indexOf("=")) == -1) continue;
            String name = line.substring(0, index).trim();
            String value = line.substring(index + 1).trim();
            if (name.matches(".*\\d{1,2}")) {
                name = name.substring(0, name.lastIndexOf("."));
            }
            if ((values = map.get(name)) == null) {
                values = new ArrayList();
                map.put(name, values);
            }
            values.add(value);
        }
        reader.close();
        return map;
    }

    private String getProperty(Map<String, ArrayList<String>> prop, String name, String defaultValue) {
        ArrayList<String> values = prop.get(name);
        String value = null;
        value = values != null && values.size() > 0 ? values.get(0) : defaultValue;
        return value;
    }

    private List<String> getListProperty(Map<String, ArrayList<String>> prop, String name) {
        ArrayList<String> value = prop.get(name);
        if (value == null) {
            value = new ArrayList(0);
        }
        return value;
    }

    public static class FailureAction {
        int type;
        int delay;

        public FailureAction(String type, String delay) {
            if (type != null) {
                this.type = type.equalsIgnoreCase("restart") ? 1 : (type.equalsIgnoreCase("reboot") ? 2 : (type.equalsIgnoreCase("run_command") ? 3 : 0));
            }
            this.delay = Integer.parseInt(delay);
        }

        public int getType() {
            return this.type;
        }

        public int getDelay() {
            return this.delay;
        }
    }
}

