/*
 * Decompiled with CFR 0.152.
 */
package oracle.jdbc.driver;

import java.io.IOException;
import java.sql.SQLException;
import java.sql.SQLRecoverableException;
import java.sql.SQLWarning;
import java.util.Arrays;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CompletionStage;
import java.util.function.Consumer;
import java.util.logging.Level;
import oracle.jdbc.ErrorSet;
import oracle.jdbc.OracleConnection;
import oracle.jdbc.clio.annotations.Format;
import oracle.jdbc.diagnostics.Metrics;
import oracle.jdbc.diagnostics.Parameter;
import oracle.jdbc.diagnostics.SecurityLabel;
import oracle.jdbc.driver.DatabaseError;
import oracle.jdbc.driver.LogicalTransactionId;
import oracle.jdbc.driver.NTFLTXIDEvent;
import oracle.jdbc.driver.NTFXSEvent;
import oracle.jdbc.driver.Pipeline;
import oracle.jdbc.driver.ReplayContext;
import oracle.jdbc.driver.StateSignatures;
import oracle.jdbc.driver.T4CConnection;
import oracle.jdbc.driver.T4CTTIMsg;
import oracle.jdbc.driver.T4CTTIkvarr;
import oracle.jdbc.driver.T4CTTIoer11;
import oracle.jdbc.driver.T4CTTIoping;
import oracle.jdbc.driver.T4CTTIoplopn;
import oracle.jdbc.driver.T4CTTIqcinv;
import oracle.jdbc.driver.TemplateOverflow;
import oracle.jdbc.driver.utils.ThrowingRunnable;
import oracle.jdbc.internal.Monitor;
import oracle.jdbc.internal.OracleConnection;
import oracle.jdbc.replay.ReplayableConnection;
import oracle.net.ns.BreakNetException;

abstract class T4CTTIfun
extends T4CTTIMsg {
    private static final String CLASS_NAME = T4CTTIfun.class.getName();
    static final short OOPEN = 2;
    static final short OFETCH = 5;
    static final short OCLOSE = 8;
    static final short OLOGOFF = 9;
    static final short OCOMON = 12;
    static final short OCOMOFF = 13;
    static final short OCOMMIT = 14;
    static final short OROLLBACK = 15;
    static final short OCANCEL = 20;
    static final short ODSCRARR = 43;
    static final short OVERSION = 59;
    static final short OK2RPC = 67;
    static final short OALL7 = 71;
    static final short OSQL7 = 74;
    static final short OEXFEN = 78;
    static final short O3LOGON = 81;
    static final short O3LOGA = 82;
    static final short OKOD = 92;
    static final short OALL8 = 94;
    static final short OLOBOPS = 96;
    static final short ODNY = 98;
    static final short OTXSE = 103;
    static final short OTXEN = 104;
    static final short OCCA = 105;
    static final short O80SES = 107;
    static final short ODSY = 119;
    static final short OAUTH = 115;
    static final short OSESSKEY = 118;
    static final short OCANA = 120;
    static final short OKPN = 125;
    static final short OOTCM = 127;
    static final short OSCID = 135;
    static final short OSPFPPUT = 138;
    static final short OKPFC = 139;
    static final short OPING = 147;
    static final short OKEYVAL = 154;
    static final short OXSSCS = 155;
    static final short OXSSRO = 156;
    static final short OXSSPO = 157;
    static final short OAQEQ = 121;
    static final short OAQDQ = 122;
    static final short OAQGPS = 132;
    static final short OAQLS = 126;
    static final short OAQXQ = 145;
    static final short OSESSGET = 162;
    static final short OSESSRLS = 163;
    static final short OSSTEMPLATE = 164;
    static final short OQCSTA = 167;
    static final short OQCID = 168;
    static final short OXSNSO = 172;
    static final short OXSNS = 178;
    static final short OXSSYNC = 176;
    static final short OXSATT = 180;
    static final short OXSCRE = 179;
    static final short OXSDET = 181;
    static final short OXSDES = 182;
    static final short OXSSET = 183;
    static final short OSESSSTATE = 176;
    static final short OAPPCONTREPLAY = 177;
    static final short OAQENQ = 184;
    static final short OAQDEQ = 185;
    static final short OAQEMNDEQ = 186;
    static final short OAQNFY = 187;
    static final short OCHUNKINFO = 190;
    static final short OCLFEATURES = 191;
    static final short OSAGA = 195;
    static final short ODPP = 128;
    static final short ODPMOP = 130;
    static final short ODPLS = 129;
    static final short OPLBGN = 199;
    static final short OPLEND = 200;
    static final short OPLOPN = 203;
    private short funCode;
    private static final String FUN_CODE_DESCRIPTION_OTHER = "OTHER";
    private static final String[] FUN_CODE_DESCRIPTIONS = new String[256];
    protected byte sequenceNumber;
    private long tokenNumber;
    private SQLException marshallingException;
    private boolean isDrainingCancel = false;
    int receiveState = 0;
    static final int IDLE_RECEIVE_STATE = 0;
    static final int ACTIVE_RECEIVE_STATE = 1;
    static final int READROW_RECEIVE_STATE = 2;
    static final int STREAM_RECEIVE_STATE = 3;
    boolean rpaProcessed = false;
    boolean rxhProcessed = false;
    boolean iovProcessed = false;
    private final short[] ttiList;
    private int ttiListEnd = 0;
    ReplayContext replayContext = null;
    StateSignatures stateSignatures = null;
    TemplateOverflow templateOverflow = null;

    protected static String getFunCodeDescription(short funCode) {
        return FUN_CODE_DESCRIPTIONS[funCode];
    }

    T4CTTIfun(T4CConnection _conn, byte _ttcCode) {
        super(_conn, _ttcCode);
        this.ttiList = _conn.ttiList;
    }

    final void setFunCode(short _funCode) {
        this.funCode = _funCode;
    }

    final short getFunCode() {
        return this.funCode;
    }

    private final void marshalFunHeader(long tokenNumber) throws IOException {
        this.marshalTTCcode();
        this.connection.lastExecutedFunCode(this.funCode);
        this.meg.marshalUB1(this.funCode);
        this.sequenceNumber = this.connection.getNextSeqNumber();
        this.meg.marshalUB1(this.sequenceNumber);
        this.debug(Level.FINE, SecurityLabel.UNKNOWN, CLASS_NAME, "marshalFunHeader", "func={0} sequenceNumber={1} tokenNumber={2}", (String)null, (Throwable)null, (Object)this.funCode, (Object)this.sequenceNumber, (Object)tokenNumber);
        if (this.connection.getTTCVersion() >= 18) {
            this.meg.marshalUB8(tokenNumber);
        }
    }

    abstract void marshal() throws IOException;

    final void doRPC() throws IOException, SQLException {
        this.beforeRoundTrip();
        if (this.connection.pipeline() != null) {
            this.connection.pipeline().await();
        }
        this.drainCancel();
        this.requireNonPiggyBackFunction();
        this.connection.setExecutingRPCFunctionCode(this.funCode);
        this.connection.checkEndReplayCallback();
        this.sendPiggyBackMessages();
        try {
            this.connection.pipeState = 1;
            this.send(0L);
            this.connection.pipeState = 2;
            this.receive();
            this.afterRoundTrip(false);
        }
        catch (SQLException sqlEx) {
            SQLException rpcFailure = this.handleRpcFailure(sqlEx);
            this.afterRoundTrip(true);
            throw rpcFailure;
        }
        finally {
            this.handleRpcCompletionAlways();
        }
    }

    private void beforeRoundTrip() {
        this.connection.beforeRoundTrip(T4CTTIfun.getFunCodeDescription(this.funCode));
    }

    private void afterRoundTrip(Boolean isCompletedExceptionally) {
        this.connection.afterRoundTrip(isCompletedExceptionally);
    }

    private void requireNonPiggyBackFunction() throws SQLException {
        if (this.getTTCCode() == 17) {
            throw (SQLException)DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 401).fillInStackTrace();
        }
    }

    private void sendPiggyBackMessages() throws SQLException, IOException {
        if (this.connection.isResultSetCacheActive()) {
            this.sendTTIQC();
        }
        this.connection.sendPiggyBackedMessages(this.getFunCode() == 9);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void drainCancel() throws SQLException, IOException {
        if (this.isDrainingCancel) {
            return;
        }
        try (Monitor.CloseableLock lock = this.connection.cancelInProgressLockForThin.acquireCloseableLock();){
            if (!this.connection.cancelInProgressFlag) {
                return;
            }
            T4CTTIoping oping = this.connection.oping;
            oping.isDrainingCancel = true;
            try {
                this.debug(Level.FINER, SecurityLabel.UNKNOWN, CLASS_NAME, "drainCancel", "Sending OPING to drain ORA-01013 error", null, null);
                oping.doRPC();
            }
            catch (SQLException sqlException) {
                if (!this.isCanceledError(sqlException)) {
                    throw sqlException;
                }
            }
            finally {
                oping.isDrainingCancel = false;
            }
        }
    }

    private void send(long tokenNumber) throws IOException {
        this.init();
        this.connection.enterMarshalling();
        this.marshalFunHeader(tokenNumber);
        this.marshal();
    }

    private SQLException handleRpcFailure(SQLException sqlException) {
        this.redoCursorClose();
        if (this.isCanceledError(sqlException)) {
            try (Monitor.CloseableLock lock = this.connection.cancelInProgressLockForThin.acquireCloseableLock();){
                this.connection.cancelInProgressFlag = false;
            }
            if (this.marshallingException != null) {
                SQLException marshallingException = this.marshallingException;
                this.marshallingException = null;
                return marshallingException;
            }
        }
        return sqlException;
    }

    private void handleRpcCompletionAlways() {
        this.connection.pipeState = -1;
        this.connection.lastPiggyBackCursorCloseSeqNumber = 0;
    }

    final CompletionStage<Void> doRPCAsync() {
        return this.doRPCAsync(ErrorSet.ALL_ERRORS);
    }

    final CompletionStage<Void> doRPCAsync(ErrorSet continueOnErrorSet) {
        CompletableFuture<Void> future = new CompletableFuture<Void>();
        this.doRPCAsync(continueOnErrorSet, error -> {
            if (error == null) {
                future.complete(null);
            } else {
                future.completeExceptionally((Throwable)error);
            }
        });
        return future;
    }

    final void doRPCAsync(Consumer<Throwable> callback) {
        this.doRPCAsync(ErrorSet.ALL_ERRORS, callback);
    }

    final void doRPCAsync(ErrorSet continueOnErrorSet, Consumer<Throwable> callback) {
        this.doRPCAsync(continueOnErrorSet, () -> {}, callback);
    }

    final void doRPCAsync(ErrorSet continueOnErrorSet, ThrowingRunnable<Exception> startCallback, Consumer<Throwable> completionCallback) {
        try {
            if (this.connection.acProxy != null) {
                ((ReplayableConnection)this.connection.acProxy).disableReplay();
            }
            this.requireNonPiggyBackFunction();
        }
        catch (Throwable throwable) {
            completionCallback.accept(throwable);
            return;
        }
        this.drainCancelForPipeline();
        Pipeline.IoTask ioTask = this.createIoTask(continueOnErrorSet, startCallback, completionCallback);
        this.connection.pipeline().execute(ioTask);
    }

    private void drainCancelForPipeline() {
        if (this.isDrainingCancel) {
            return;
        }
        Pipeline pipeline = this.connection.pipeline();
        try (Monitor.CloseableLock lock = this.connection.cancelInProgressLockForThin.acquireCloseableLock();){
            if (pipeline.isExecuting()) {
                return;
            }
            if (!this.connection.cancelInProgressFlag) {
                return;
            }
            T4CTTIoping oping = new T4CTTIoping(this.connection);
            oping.isDrainingCancel = true;
            oping.doRPCAsync(ErrorSet.NO_ERRORS, error -> {
                oping.isDrainingCancel = false;
            });
            pipeline.resume();
        }
    }

    private Pipeline.IoTask createIoTask(ErrorSet continueOnErrorSet, ThrowingRunnable<Exception> startCallback, Consumer<Throwable> completionCallback) {
        Pipeline pipeline = this.connection.pipeline();
        RpcIoTask ioTask = pipeline.isPipelinable(this.funCode) && pipeline.communicationMode() == Pipeline.CommunicationMode.FULL_DUPLEX ? new PipelinedIoTask(continueOnErrorSet, startCallback, completionCallback) : new NonPipelinedIoTask(continueOnErrorSet, startCallback, completionCallback);
        return this.decorateIoTask(ioTask);
    }

    protected Pipeline.IoTask decorateIoTask(Pipeline.IoTask ioTask) {
        return ioTask;
    }

    private final void sendTTIQC() throws IOException, SQLException {
        this.connection.enterMarshalling();
        this.meg.marshalUB1((short)24);
        this.connection.kpdqidcscn.setSCN(this.connection.getResultSetCacheVisibleSCN());
        this.connection.kpdqidcscn.marshal();
        this.connection.exitMarshalling();
    }

    final void doPigRPC() throws IOException {
        this.init();
        this.connection.enterMarshalling();
        this.marshalFunHeader(0L);
        this.marshal();
        this.connection.exitMarshalling();
    }

    final void doOneWayRPC() throws IOException, SQLException {
        this.connection.pipeline().await();
        this.connection.sendPiggyBackedMessages();
        this.init();
        this.connection.enterMarshalling();
        this.marshalFunHeader(0L);
        this.marshal();
        this.meg.flush();
        this.connection.exitMarshalling();
    }

    private void init() {
        this.rpaProcessed = false;
        this.rxhProcessed = false;
        this.iovProcessed = false;
        this.ttiListEnd = 0;
    }

    void resumeReceive() throws SQLException, IOException {
        this.receive();
    }

    private final String ttiListString() {
        Object s = "[ ";
        for (int i = 0; i < this.ttiListEnd; ++i) {
            s = (String)s + this.ttiList[i] + ", ";
        }
        s = (String)s + "]";
        return s;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Unable to fully structure code
     */
    private final void receive() throws SQLException, IOException {
        this.receiveState = 1;
        this.replayContext = null;
        this.stateSignatures = null;
        this.templateOverflow = null;
        try {
            exceptionToBeThrown = null;
            block43: while (true) lbl-1000:
            // 24 sources

            {
                try {
                    code = this.meg.unmarshalUB1();
                    if (this.ttiListEnd < this.ttiList.length) {
                        this.ttiList[this.ttiListEnd++] = code;
                    }
                    this.debug(Level.FINER, SecurityLabel.UNKNOWN, T4CTTIfun.CLASS_NAME, "receive", "code={0} func={1}", (String)null, (Throwable)null, (Object)code, (Object)this.funCode);
                    switch (code) {
                        case 33: {
                            this.processTKN(this.meg.unmarshalSB8());
                            ** break;
                        }
                        case 8: {
                            if (this.rpaProcessed) {
                                throw (SQLException)DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 401).fillInStackTrace();
                            }
                            this.readRPA();
                            try {
                                this.processRPA();
                            }
                            catch (SQLException ex) {
                                exceptionToBeThrown = ex;
                            }
                            this.rpaProcessed = true;
                            ** break;
                        }
                        case 21: {
                            this.readBVC();
                            ** break;
                        }
                        case 11: {
                            this.readIOV();
                            this.iovProcessed = true;
                            ** break;
                        }
                        case 6: {
                            this.readRXH();
                            this.rxhProcessed = true;
                            ** break;
                        }
                        case 12: {
                            this.processSLG();
                            ** break;
                        }
                        case 7: {
                            this.receiveState = 2;
                            if (this.readRXD()) {
                                this.receiveState = 3;
                                return;
                            }
                            this.receiveState = 1;
                            ** break;
                        }
                        case 16: {
                            this.readDCB();
                            ** break;
                        }
                        case 14: {
                            this.readLOBD();
                            ** break;
                        }
                        case 25: {
                            this.readRSH();
                            ** break;
                        }
                        case 23: {
                            this.readSPF();
                            ** break;
                        }
                        case 19: {
                            this.meg.marshalUB1((short)19);
                            ** break;
                        }
                        case 27: {
                            this.readIMPLRES();
                            ** break;
                        }
                        case 15: {
                            this.connection.getT4CTTIoer().init();
                            this.connection.getT4CTTIoer().unmarshalWarning();
                            try {
                                this.connection.getT4CTTIoer().processWarning();
                            }
                            catch (SQLWarning ea) {
                                this.connection.setWarnings(DatabaseError.addSqlWarning(this.connection.getWarnings(), ea));
                            }
                            continue block43;
                        }
                        case 9: {
                            this.processEOCS();
                            if (this.connection.getTTCVersion() >= 3) {
                                this.connection.endToEndECIDSequenceNumber = _endToEndECIDSequenceNumber = (short)this.meg.unmarshalUB2();
                            }
                            break block43;
                        }
                        case 13: {
                            this.readOAC();
                            ** break;
                        }
                        case 4: {
                            this.processEOCS();
                            oer = this.connection.getT4CTTIoer();
                            oer.init();
                            this.unmarshalError();
                            try {
                                if (oer.callNumber == this.sequenceNumber) {
                                    this.processError();
                                    break block43;
                                }
                                this.handleOutOfSequenceError(oer);
                            }
                            catch (SQLException sqlex) {
                                exceptionToBeThrown = sqlex;
                            }
                            break block43;
                        }
                        case 28: {
                            if (this.connection.currentConnectionPath == T4CConnection.ConnectionPath.COOKIE) {
                                this.end(Metrics.ConnectionEvent.TTC_TTICOOKIE_OPTIMIZATION);
                            }
                            if (this.connection.currentConnectionPath == T4CConnection.ConnectionPath.TTIINIT) {
                                this.end(Metrics.ConnectionEvent.TTC_TTIINIT_OPTIMIZATION);
                            }
                            this.debug(Level.FINEST, SecurityLabel.UNKNOWN, T4CTTIfun.CLASS_NAME, "receive", "TTIRENEG received from the server", null, null);
                            this.begin(Metrics.ConnectionEvent.TTC_RENEGOTIATION);
                            this.connection.reNegotiateTTCProDty();
                            this.end(Metrics.ConnectionEvent.TTC_RENEGOTIATION);
                            if (this.processRENEG()) continue block43;
                            break block43;
                        }
                        case 2: {
                            this.connection.processTTIDtyResponse();
                            if (this.connection.currentConnectionPath == T4CConnection.ConnectionPath.COOKIE) {
                                this.end(Metrics.ConnectionEvent.TTC_TTICOOKIE_OPTIMIZATION);
                            }
                            if (this.connection.currentConnectionPath != T4CConnection.ConnectionPath.TTIINIT) continue block43;
                            this.end(Metrics.ConnectionEvent.TTC_TTIINIT_OPTIMIZATION);
                            ** break;
                        }
                        case 1: {
                            if (!this.connection.isLoggedOn()) {
                                this.connection.processTTIProResponse();
                                ** break;
                            }
                        }
                        default: {
                            throw this.debug(Level.SEVERE, SecurityLabel.UNKNOWN, T4CTTIfun.CLASS_NAME, "receive", "Received unexpected TTC message code {0}", (String)null, (SQLException)DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 401, this.ttiListString()).fillInStackTrace(), (Object)code);
                        }
                    }
                }
                catch (SQLException e) {
                    if (e.getErrorCode() == 18738) {
                        exceptionToBeThrown = e;
                        continue;
                    }
                    throw e;
                }
                catch (BreakNetException ea) {
                    this.debug(Level.FINEST, SecurityLabel.UNKNOWN, T4CTTIfun.CLASS_NAME, "receive", "Break received from the server", null, null);
                    continue;
                }
                finally {
                    this.connection.sentCancel = false;
                    continue;
                }
                break;
            }
            this.receiveState = 0;
            if (exceptionToBeThrown != null) {
                throw exceptionToBeThrown;
            }
        }
        catch (SQLRecoverableException sqlrexc) {
            throw sqlrexc;
        }
        catch (IOException ioexc) {
            if (this.replayContext != null) {
                this.handleReplayContext(this.replayContext);
            }
            if (this.stateSignatures != null) {
                this.updateSessionState(this.stateSignatures, this.templateOverflow);
            }
            throw ioexc;
        }
        catch (SQLException allOtherException) {
            if (this.replayContext != null) {
                this.handleReplayContext(this.replayContext);
            }
            if (this.stateSignatures != null) {
                this.updateSessionState(this.stateSignatures, this.templateOverflow);
            }
            this.connection.setExecutingRPCFunctionCode((short)0);
            if (this.funCode == 94 || this.funCode == 78) {
                this.connection.setExecutingRPCSQL(null);
            }
            throw allOtherException;
        }
        if (this.replayContext != null) {
            this.handleReplayContext(this.replayContext);
        }
        if (this.stateSignatures != null) {
            this.updateSessionState(this.stateSignatures, this.templateOverflow);
        }
        this.connection.setExecutingRPCFunctionCode((short)0);
        if (this.funCode == 94 || this.funCode == 78) {
            this.connection.setExecutingRPCSQL(null);
        }
        this.connection.exitMarshalling();
    }

    private final void handleReplayContext(ReplayContext replayContext) {
        if (this.connection.replayModes.contains((Object)T4CConnection.ReplayMode.NONREQUEST)) {
            if ((replayContext.flags_kpdxcAppContCtl & 4L) == 0L && this.connection.replayModes.contains((Object)T4CConnection.ReplayMode.RUNTIME_REPLAY_ENABLED)) {
                this.debug(Level.FINE, SecurityLabel.UNKNOWN, CLASS_NAME, "handleReplayContext", "Received server DISABLE at non-request call with ORA-{0}, clearing ENABLE", (String)null, (Throwable)null, (Object)replayContext.getErrorCode());
                this.connection.replayModes.remove((Object)T4CConnection.ReplayMode.RUNTIME_REPLAY_ENABLED);
                this.connection.nonRequestDisableReplayCxt = replayContext;
            }
            return;
        }
        assert ((replayContext.flags_kpdxcAppContCtl & 4L) != 0L || replayContext.errcode_kpdxcAppContCtl != 41406L || !this.connection.replayModes.contains((Object)T4CConnection.ReplayMode.RUNTIME_REPLAY_ENABLED)) : "Server disabled replay with error " + replayContext.errcode_kpdxcAppContCtl + " but our replayModes=" + this.connection.replayModes;
        if (this.connection.thinACReplayContextReceived.length == this.connection.thinACReplayContextReceivedCurrent) {
            ReplayContext[] tmp = new ReplayContext[this.connection.thinACReplayContextReceived.length * 2];
            System.arraycopy(this.connection.thinACReplayContextReceived, 0, tmp, 0, this.connection.thinACReplayContextReceived.length);
            this.connection.thinACReplayContextReceived = tmp;
        }
        this.connection.thinACReplayContextReceived[this.connection.thinACReplayContextReceivedCurrent++] = replayContext;
        if ((replayContext.flags_kpdxcAppContCtl & 4L) == 0L && this.connection.replayModes.contains((Object)T4CConnection.ReplayMode.RUNTIME_REPLAY_ENABLED)) {
            this.debug(Level.FINEST, SecurityLabel.UNKNOWN, CLASS_NAME, "handleReplayContext", "Received a DISABLE during runtime, clearing STATIC", null, null);
            this.connection.replayModes.remove((Object)T4CConnection.ReplayMode.RUNTIME_REPLAY_ENABLED);
            this.connection.replayModes.remove((Object)T4CConnection.ReplayMode.RUNTIME_OR_REPLAYING_STATIC);
        }
        if (!(replayContext.replayctx_kpdxcAppContCtl == null || replayContext.replayctx_kpdxcAppContCtl.length <= 0 || this.connection.getExecutingRPCFunctionCode() == 115 && this.connection.ignoreReplayContextFromAuthentication)) {
            this.connection.thinACLastReplayContextReceived = replayContext;
        }
    }

    private final void updateSessionState(StateSignatures stateSignatures, TemplateOverflow templateOverflow) {
        this.connection.updateSessionState(stateSignatures, templateOverflow);
    }

    private final void processEOCS() throws SQLException, IOException {
        if (this.connection.hasServerCompileTimeCapability(15, 1)) {
            int ucaeocs;
            this.connection.eocs = ucaeocs = (int)this.meg.unmarshalUB4();
            if ((ucaeocs & 8) != 0) {
                long elapsedTime = this.meg.unmarshalSB8();
                this.debug(Level.FINE, SecurityLabel.UNKNOWN, CLASS_NAME, "processEOCS", "elapsed time={0}", (String)null, (Throwable)null, (Object)elapsedTime);
            }
            if ((ucaeocs & 0x800) != 0) {
                this.trace(Level.INFO, SecurityLabel.UNKNOWN, CLASS_NAME, "processEOCS", "got in-band planned down bit, mark connection for close={0}", null, null, this.connection);
                this.connection.setNeedsToBeClosed(true);
            }
            if ((ucaeocs & 0x8000) != 0 && this.connection.statements != null) {
                this.connection.drcpState = OracleConnection.DRCPState.DETACHED;
                this.connection.statements.clearCursorId();
                this.connection.cleanStatementCache();
            }
        }
    }

    void processRPA() throws SQLException {
    }

    void readOAC() throws SQLException, IOException {
    }

    void readRSH() throws IOException, SQLException {
    }

    void readRPA() throws IOException, SQLException {
    }

    void readBVC() throws IOException, SQLException {
        throw (SQLException)DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 401).fillInStackTrace();
    }

    void readLOBD() throws IOException, SQLException {
        throw (SQLException)DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 401).fillInStackTrace();
    }

    void readIOV() throws IOException, SQLException {
        throw (SQLException)DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 401).fillInStackTrace();
    }

    void readRXH() throws IOException, SQLException {
        throw (SQLException)DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 401).fillInStackTrace();
    }

    boolean readRXD() throws IOException, SQLException {
        throw (SQLException)DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 401).fillInStackTrace();
    }

    void readIMPLRES() throws IOException, SQLException {
        throw (SQLException)DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 401).fillInStackTrace();
    }

    void readDCB() throws IOException, SQLException {
        throw (SQLException)DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 401).fillInStackTrace();
    }

    void processSLG() throws IOException, SQLException {
        throw (SQLException)DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 401).fillInStackTrace();
    }

    void processOCSHRDKEY(byte[] buf) throws SQLException {
        throw (SQLException)DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 401).fillInStackTrace();
    }

    protected boolean processRENEG() {
        return true;
    }

    private final void readSPF() throws IOException, SQLException {
        byte opCode = (byte)this.meg.unmarshalUB1();
        switch (opCode) {
            case 1: {
                int nbOfDtys = this.meg.unmarshalUB2();
                byte lengthOfDty = (byte)this.meg.unmarshalUB1();
                for (int i = 0; i < nbOfDtys; ++i) {
                    T4CTTIqcinv[] kpdqidcusr;
                    T4CTTIqcinv[] kpdqidccinv;
                    this.connection.kpdqidcscn.unmarshal();
                    int kpdqidccinvl = this.meg.unmarshalSWORD();
                    if (kpdqidccinvl > 0) {
                        byte lengthOfDty2 = (byte)this.meg.unmarshalUB1();
                        kpdqidccinv = new T4CTTIqcinv[kpdqidccinvl];
                        for (int ii = 0; ii < kpdqidccinvl; ++ii) {
                            kpdqidccinv[ii] = new T4CTTIqcinv(this.connection);
                            kpdqidccinv[ii].unmarshal();
                            this.connection.getResultSetCacheInternal().processCommittedInvalidation(kpdqidccinv[ii]);
                        }
                    } else {
                        kpdqidccinv = null;
                    }
                    this.connection.getResultSetCacheLocalInvalidations().clear();
                    int kpdqidcusrl = this.meg.unmarshalSWORD();
                    if (kpdqidcusrl > 0) {
                        byte lengthOfDty2 = (byte)this.meg.unmarshalUB1();
                        kpdqidcusr = new T4CTTIqcinv[kpdqidcusrl];
                        for (int ii = 0; ii < kpdqidcusrl; ++ii) {
                            kpdqidcusr[ii] = new T4CTTIqcinv(this.connection);
                            kpdqidcusr[ii].unmarshal();
                            this.connection.getResultSetCacheLocalInvalidations().add(kpdqidcusr[ii].kpdqcqid);
                        }
                    } else {
                        kpdqidcusr = null;
                    }
                    long kpdqidcflg = this.meg.unmarshalUB4();
                    this.connection.setResultSetCacheVisibleSCN(this.connection.kpdqidcscn.getSCN());
                }
                break;
            }
            case 2: {
                int nbOfDtys = this.meg.unmarshalUB2();
                byte lengthOfDty = (byte)this.meg.unmarshalUB1();
                byte[] _ospid = this.meg.unmarshalNBytes(nbOfDtys);
                this.debug(Level.FINEST, SecurityLabel.UNKNOWN, CLASS_NAME, "readSPF", "  mtspid = {0}", (String)null, (Throwable)null, (Object)Parameter.arg(Format.Style.BYTE_ARRAY, _ospid, new long[0]));
                break;
            }
            case 4: {
                this.connection.ocsessret.receive();
                this.debugp(Level.FINEST, SecurityLabel.UNKNOWN, CLASS_NAME, "readSPF", "dump obj = {0}", null, null, () -> new Object[]{T4CConnection.dumpObject(this.connection.ocsessret, "  ")});
                break;
            }
            case 5: {
                int nbOfDtys = this.meg.unmarshalUB2();
                byte lengthOfDty = (byte)this.meg.unmarshalUB1();
                T4CTTIkvarr kvarr = new T4CTTIkvarr(this.connection);
                kvarr.unmarshal();
                if (kvarr.kpdkvarrptr == null) break;
                this.connection.updateSessionProperties(kvarr.kpdkvarrptr);
                break;
            }
            case 7: {
                LogicalTransactionId ltxid;
                assert (this.connection.enableTGSupport || this.connection.enableACSupport) : "Driver TG/AC support is disabled but server still sent LTXID piggyback";
                byte[] ltxidbytes = this.meg.unmarshalDALC();
                int ltxidHash = Arrays.hashCode(ltxidbytes);
                if (this.connection.thinACLastLtxidHash == ltxidHash) break;
                this.connection.thinACCurrentLTXID = ltxid = new LogicalTransactionId(ltxidbytes);
                NTFLTXIDEvent ltxidevent = new NTFLTXIDEvent(this.connection, ltxid);
                this.connection.notify(ltxidevent);
                this.connection.thinACLastLtxidHash = ltxidHash;
                break;
            }
            case 9: {
                int nbOfDtys = this.meg.unmarshalUB2();
                byte lengthOfDty = (byte)this.meg.unmarshalUB1();
                for (int i = 0; i < nbOfDtys; ++i) {
                    NTFXSEvent xsevent = new NTFXSEvent(this.connection);
                    this.connection.notify(xsevent);
                }
                break;
            }
            case 8: {
                int nbOfDtys = this.meg.unmarshalUB2();
                byte lengthOfDty = (byte)this.meg.unmarshalUB1();
                long flags_kpdxcAppContCtl = this.meg.unmarshalUB4();
                long errcode_kpdxcAppContCtl = this.meg.unmarshalUB4();
                short queue_kpdxcAppContCtl = this.meg.unmarshalUB1();
                byte[] replayctx_kpdxcAppContCtl = this.meg.unmarshalDALC();
                this.replayContext = new ReplayContext(flags_kpdxcAppContCtl, queue_kpdxcAppContCtl, replayctx_kpdxcAppContCtl, errcode_kpdxcAppContCtl);
                if (!this.connection.cancelInProgressFlag || !this.replayContext.isDuplicate(this.connection.thinACLastReplayContextReceived)) break;
                this.debug(Level.FINEST, SecurityLabel.UNKNOWN, CLASS_NAME, "readSPF", "cancel in progress, FILTERED OUT duplicate replay context: {0}", (String)null, (Throwable)null, (Object)this.replayContext);
                this.replayContext = null;
                break;
            }
            case 10: {
                assert (this.connection.enableACSupport) : "Driver AC support is disabled but server still sent state-signatures piggyback";
                int nbOfDtys = this.meg.unmarshalUB2();
                byte lengthOfDty = (byte)this.meg.unmarshalUB1();
                long signatureFlags = this.meg.unmarshalSB8();
                long clientSignature = this.meg.unmarshalSB8();
                long serverSignature = this.meg.unmarshalSB8();
                if (this.connection.hasServerCompileTimeCapability(39, 15)) {
                    long signatureVer = this.meg.unmarshalUB4();
                    this.stateSignatures = new StateSignatures(signatureFlags, clientSignature, serverSignature, signatureVer);
                    long templateId = this.meg.unmarshalSB8();
                    byte[] overflow = this.meg.unmarshalDALC();
                    long overflowSig = this.meg.unmarshalSB8();
                    long OVERFLOW_FULL = 64L;
                    boolean isFullOverflow = (signatureFlags & OVERFLOW_FULL) == OVERFLOW_FULL;
                    this.templateOverflow = new TemplateOverflow(templateId, overflow, isFullOverflow, overflowSig);
                    break;
                }
                this.stateSignatures = new StateSignatures(signatureFlags, clientSignature, serverSignature);
                break;
            }
            case 11: {
                int nbOfDtys = this.meg.unmarshalUB2();
                byte lengthOfDty = (byte)this.meg.unmarshalUB1();
                byte[] buf = this.meg.unmarshalDALC();
                this.processOCSHRDKEY(buf);
                break;
            }
            default: {
                throw (SQLException)DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 401, this.ttiListString()).fillInStackTrace();
            }
        }
    }

    void unmarshalError() throws IOException, SQLException {
        this.connection.getT4CTTIoer().unmarshal();
    }

    void processError() throws SQLException {
        this.connection.getT4CTTIoer().processError();
    }

    final long getErrorCode() throws SQLException {
        return this.connection.getT4CTTIoer().retCode;
    }

    @Override
    protected OracleConnection getConnectionDuringExceptionHandling() {
        return null;
    }

    protected void processTKN(long tokenNumber) throws SQLException {
        if (this.tokenNumber != tokenNumber) {
            throw DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 401, "Unexpected token number: " + tokenNumber + ". Expected token number: " + this.tokenNumber);
        }
    }

    private boolean redoCursorClose() {
        if (this.connection.lastPiggyBackCursorCloseSeqNumber != 0 && this.connection.getT4CTTIoer().callNumber != this.connection.currentTTCSeqNumber) {
            short j;
            short s = j = this.connection.getT4CTTIoer().callNumber == 127 ? (short)1 : (short)(this.connection.getT4CTTIoer().callNumber + 1);
            while (j != this.connection.currentTTCSeqNumber) {
                if (this.connection.lastPiggyBackCursorCloseSeqNumber == j) {
                    return true;
                }
                if (j == 127) {
                    j = 1;
                    continue;
                }
                j = (short)(j + 1);
            }
        }
        return false;
    }

    private boolean isCanceledError(SQLException sqlException) {
        return sqlException.getErrorCode() == 1013 || this.connection.cancelInProgressFlag && sqlException.getMessage() != null && sqlException.getMessage().contains("ORA-01013");
    }

    protected void setMarshallingException(SQLException marshallingException) {
        if (this.marshallingException != null && this.marshallingException != marshallingException) {
            marshallingException.addSuppressed(this.marshallingException);
        }
        this.marshallingException = marshallingException;
    }

    private void handleOutOfSequenceError(T4CTTIoer11 oer) throws SQLException {
        this.debug(Level.FINER, SecurityLabel.UNKNOWN, CLASS_NAME, "handleOutOfSequenceError", "TTIOER call number {0} does not match TTIFUN sequence number {1}", (String)null, (Throwable)null, (Object)oer.callNumber, (Object)this.sequenceNumber);
        if (this.connection.cancelInProgressFlag && this.replayContext != null) {
            this.debug(Level.FINEST, SecurityLabel.UNKNOWN, CLASS_NAME, "handleOutOfSequenceError", "cancel in progress, FILTERED OUT duplicate replay context at OER: {0}", (String)null, (Throwable)null, (Object)this.replayContext);
            this.replayContext = null;
        }
        oer.processError(true);
    }

    static {
        Arrays.fill(FUN_CODE_DESCRIPTIONS, FUN_CODE_DESCRIPTION_OTHER);
        T4CTTIfun.FUN_CODE_DESCRIPTIONS[2] = "Open a cursor";
        T4CTTIfun.FUN_CODE_DESCRIPTIONS[5] = "Fetch a row";
        T4CTTIfun.FUN_CODE_DESCRIPTIONS[8] = "Close a cursor";
        T4CTTIfun.FUN_CODE_DESCRIPTIONS[9] = "Logoff of ORACLE";
        T4CTTIfun.FUN_CODE_DESCRIPTIONS[12] = "Auto commit on";
        T4CTTIfun.FUN_CODE_DESCRIPTIONS[13] = "Auto commit off";
        T4CTTIfun.FUN_CODE_DESCRIPTIONS[14] = "Commit";
        T4CTTIfun.FUN_CODE_DESCRIPTIONS[15] = "Rollback";
        T4CTTIfun.FUN_CODE_DESCRIPTIONS[20] = "Cancel the current operation";
        T4CTTIfun.FUN_CODE_DESCRIPTIONS[43] = "Array describe";
        T4CTTIfun.FUN_CODE_DESCRIPTIONS[59] = "Get ORACLE version-date string in new format";
        T4CTTIfun.FUN_CODE_DESCRIPTIONS[67] = "Distributed transaction manager RPC";
        T4CTTIfun.FUN_CODE_DESCRIPTIONS[81] = "Second half of challenge-response logon";
        T4CTTIfun.FUN_CODE_DESCRIPTIONS[82] = "First half of challenge-response logon";
        T4CTTIfun.FUN_CODE_DESCRIPTIONS[94] = "Execute query";
        T4CTTIfun.FUN_CODE_DESCRIPTIONS[96] = "LOB and FILE related calls";
        T4CTTIfun.FUN_CODE_DESCRIPTIONS[98] = "New describe query call";
        T4CTTIfun.FUN_CODE_DESCRIPTIONS[103] = "Transaction start, attach, detach";
        T4CTTIfun.FUN_CODE_DESCRIPTIONS[104] = "Transaction commit, rollback, recover";
        T4CTTIfun.FUN_CODE_DESCRIPTIONS[105] = "Cursor close all";
        T4CTTIfun.FUN_CODE_DESCRIPTIONS[107] = "V8 session switching piggyback";
        T4CTTIfun.FUN_CODE_DESCRIPTIONS[119] = "V8 Describe Any";
        T4CTTIfun.FUN_CODE_DESCRIPTIONS[115] = "Generic authentication call";
        T4CTTIfun.FUN_CODE_DESCRIPTIONS[118] = "Get the session key";
        T4CTTIfun.FUN_CODE_DESCRIPTIONS[120] = "Cancel All";
        T4CTTIfun.FUN_CODE_DESCRIPTIONS[125] = "Kernel Programmatic Notification";
        T4CTTIfun.FUN_CODE_DESCRIPTIONS[135] = "end2end tracing message";
        T4CTTIfun.FUN_CODE_DESCRIPTIONS[138] = "Put parameter using spfile (for startup)";
        T4CTTIfun.FUN_CODE_DESCRIPTIONS[147] = "Ping";
        T4CTTIfun.FUN_CODE_DESCRIPTIONS[154] = "Client app context, namespace, attribute, values";
        T4CTTIfun.FUN_CODE_DESCRIPTIONS[155] = "eXtensible Security Sessions Create Session";
        T4CTTIfun.FUN_CODE_DESCRIPTIONS[156] = "eXtensible Security  Session Roundtrip";
        T4CTTIfun.FUN_CODE_DESCRIPTIONS[157] = "eXtensible Security Sessions Piggyback";
        T4CTTIfun.FUN_CODE_DESCRIPTIONS[121] = "AQ EnQueue";
        T4CTTIfun.FUN_CODE_DESCRIPTIONS[122] = "AQ Dequeue before 8.1";
        T4CTTIfun.FUN_CODE_DESCRIPTIONS[132] = "AQ get propagation status entries";
        T4CTTIfun.FUN_CODE_DESCRIPTIONS[126] = "AQ Listen";
        T4CTTIfun.FUN_CODE_DESCRIPTIONS[145] = "AQ Array Enqueue/Dequeue";
        T4CTTIfun.FUN_CODE_DESCRIPTIONS[162] = "Session get RPC in server pool scenario";
        T4CTTIfun.FUN_CODE_DESCRIPTIONS[163] = "Session get RPC in server pool scenario";
        T4CTTIfun.FUN_CODE_DESCRIPTIONS[164] = "Session state template";
        T4CTTIfun.FUN_CODE_DESCRIPTIONS[167] = "Client query cache statistics update";
        T4CTTIfun.FUN_CODE_DESCRIPTIONS[168] = "Client query cache IDs";
        T4CTTIfun.FUN_CODE_DESCRIPTIONS[172] = "XS namespace OPs";
        T4CTTIfun.FUN_CODE_DESCRIPTIONS[178] = "XS Namespace OP";
        T4CTTIfun.FUN_CODE_DESCRIPTIONS[176] = "XS State Sync OP";
        T4CTTIfun.FUN_CODE_DESCRIPTIONS[180] = "XS Attach Session";
        T4CTTIfun.FUN_CODE_DESCRIPTIONS[179] = "XS Create Session";
        T4CTTIfun.FUN_CODE_DESCRIPTIONS[181] = "XS Detach Session";
        T4CTTIfun.FUN_CODE_DESCRIPTIONS[182] = "XS Destroy Session";
        T4CTTIfun.FUN_CODE_DESCRIPTIONS[183] = "XS Set Session Parameter";
        T4CTTIfun.FUN_CODE_DESCRIPTIONS[176] = "Session state ops";
        T4CTTIfun.FUN_CODE_DESCRIPTIONS[177] = "Application continuity REPLAY";
        T4CTTIfun.FUN_CODE_DESCRIPTIONS[184] = "AQ Sharded enqueue";
        T4CTTIfun.FUN_CODE_DESCRIPTIONS[185] = "AQ Sharded dequeue";
        T4CTTIfun.FUN_CODE_DESCRIPTIONS[186] = "AQ 12c emon dequeue";
        T4CTTIfun.FUN_CODE_DESCRIPTIONS[187] = "12c notification receive";
        T4CTTIfun.FUN_CODE_DESCRIPTIONS[190] = "Chunk info RPC";
        T4CTTIfun.FUN_CODE_DESCRIPTIONS[191] = "Client features";
        T4CTTIfun.FUN_CODE_DESCRIPTIONS[195] = "DBMS Sagas";
        T4CTTIfun.FUN_CODE_DESCRIPTIONS[128] = "Direct Path Prepare";
        T4CTTIfun.FUN_CODE_DESCRIPTIONS[130] = "Direct Path Misc Operations";
        T4CTTIfun.FUN_CODE_DESCRIPTIONS[129] = "Direct Path Load Stream";
        T4CTTIfun.FUN_CODE_DESCRIPTIONS[199] = "Pipeline Begin Piggyback";
        T4CTTIfun.FUN_CODE_DESCRIPTIONS[200] = "Pipeline End";
        T4CTTIfun.FUN_CODE_DESCRIPTIONS[203] = "Pipeline Operation Piggyback";
    }

    private final class NonPipelinedIoTask
    extends RpcIoTask {
        NonPipelinedIoTask(ErrorSet continueOnErrorSet, ThrowingRunnable<Exception> startCallback, Consumer<Throwable> completionCallback) {
            super(continueOnErrorSet, startCallback, completionCallback);
        }

        @Override
        public Pipeline.IoStatus send() throws Exception {
            Pipeline.IoStatus status = super.send();
            T4CTTIfun.this.meg.flush();
            return status;
        }
    }

    private final class PipelinedIoTask
    extends RpcIoTask {
        private volatile boolean isSendIncomplete;

        PipelinedIoTask(ErrorSet continueOnErrorSet, ThrowingRunnable<Exception> startCallback, Consumer<Throwable> completionCallback) {
            super(continueOnErrorSet, startCallback, completionCallback);
            this.isSendIncomplete = false;
        }

        @Override
        public Pipeline.IoStatus send() throws Exception {
            if (this.isSendIncomplete) {
                this.isSendIncomplete = !T4CTTIfun.this.meg.endPipelineRequest();
                return this.isSendIncomplete ? Pipeline.IoStatus.PENDING_SEND : Pipeline.IoStatus.PENDING_RECEIVE;
            }
            T4CTTIfun.this.meg.beginPipelineRequest();
            try {
                if (this.continueOnErrorSet() != ErrorSet.ALL_ERRORS) {
                    new T4CTTIoplopn(T4CTTIfun.this.connection).doOPLOPN(0, (short)0, (short)2);
                }
                super.send();
            }
            catch (Throwable throwable) {
                this.isSendIncomplete = !T4CTTIfun.this.meg.endPipelineRequest();
                Pipeline.IoStatus ioStatus = this.isSendIncomplete ? Pipeline.IoStatus.PENDING_SEND : Pipeline.IoStatus.PENDING_RECEIVE;
                throw throwable;
            }
            this.isSendIncomplete = !T4CTTIfun.this.meg.endPipelineRequest();
            Pipeline.IoStatus ioStatus = this.isSendIncomplete ? Pipeline.IoStatus.PENDING_SEND : Pipeline.IoStatus.PENDING_RECEIVE;
            return ioStatus;
        }

        @Override
        public Pipeline.IoStatus receive() throws Exception {
            T4CTTIfun.this.meg.beginPipelineResponse();
            try {
                Pipeline.IoStatus ioStatus = super.receive();
                return ioStatus;
            }
            finally {
                T4CTTIfun.this.meg.endPipelineResponse();
            }
        }
    }

    private class RpcIoTask
    implements Pipeline.IoTask {
        private final ErrorSet continueOnErrorSet;
        private final ThrowingRunnable<Exception> startCallback;
        private boolean isFirstSend = true;
        private final Consumer<Throwable> completionCallback;

        RpcIoTask(ErrorSet continueOnErrorSet, ThrowingRunnable<Exception> startCallback, Consumer<Throwable> completionCallback) {
            this.continueOnErrorSet = continueOnErrorSet;
            this.startCallback = startCallback;
            this.completionCallback = completionCallback;
        }

        @Override
        public final short functionCode() {
            return T4CTTIfun.this.funCode;
        }

        @Override
        public final ErrorSet continueOnErrorSet() {
            return this.continueOnErrorSet;
        }

        @Override
        public Pipeline.IoStatus send() throws Exception {
            if (this.isFirstSend) {
                this.isFirstSend = false;
                this.startCallback.runOrThrow();
            }
            T4CTTIfun.this.connection.needLineUnchecked();
            T4CTTIfun.this.sendPiggyBackMessages();
            T4CTTIfun.this.tokenNumber = T4CTTIfun.this.connection.pipeline().getNextToken();
            T4CTTIfun.this.send(T4CTTIfun.this.tokenNumber);
            return Pipeline.IoStatus.PENDING_RECEIVE;
        }

        @Override
        public Pipeline.IoStatus receive() throws Exception {
            T4CTTIfun.this.connection.needLineUnchecked();
            try {
                T4CTTIfun.this.receive();
                return Pipeline.IoStatus.COMPLETE;
            }
            catch (SQLException sqlException) {
                throw T4CTTIfun.this.handleRpcFailure(sqlException);
            }
        }

        @Override
        public final void complete(Throwable error) {
            T4CTTIfun.this.handleRpcCompletionAlways();
            this.completionCallback.accept(error);
        }

        public String toString() {
            return "[function-code = " + this.functionCode() + ", function-description = " + FUN_CODE_DESCRIPTIONS[this.functionCode()] + ", continue-on-error = " + this.continueOnErrorSet() + "]";
        }
    }
}

