/*
 * Decompiled with CFR 0.152.
 */
package org.vaadin.addons.chartjs.options.annotation;

import elemental.json.JsonObject;
import java.io.Serializable;
import java.util.Arrays;
import java.util.List;
import org.vaadin.addons.chartjs.options.AnnotationOptions;
import org.vaadin.addons.chartjs.options.annotation.AbstractAnnotation;
import org.vaadin.addons.chartjs.options.annotation.LineLabel;
import org.vaadin.addons.chartjs.utils.JUtils;

public class LineAnnotation<T>
extends AbstractAnnotation<LineAnnotation<T>, T>
implements Serializable {
    private static final long serialVersionUID = -2455507357025380823L;
    private Boolean vertical;
    private String scaleID;
    private Object value;
    private Object endValue;
    private String borderColor;
    private Integer borderWidth;
    private List<Integer> borderDash;
    private Integer borderDashOffset;
    private LineLabel<T> label;

    public LineAnnotation(AnnotationOptions<T> parent) {
        super(parent, "line");
    }

    public LineAnnotation<T> vertical() {
        this.vertical = true;
        return this;
    }

    public LineAnnotation<T> horizontal() {
        this.vertical = false;
        return this;
    }

    public LineAnnotation<T> scaleID(String scaleID) {
        this.scaleID = scaleID;
        return this;
    }

    public LineAnnotation<T> xAxis0ScaleID() {
        this.scaleID = "x-axis-0";
        return this;
    }

    public LineAnnotation<T> yAxis0ScaleID() {
        this.scaleID = "y-axis-0";
        return this;
    }

    public LineAnnotation<T> value(Double value) {
        this.value = value;
        return this;
    }

    public LineAnnotation<T> value(String value) {
        this.value = value;
        return this;
    }

    public LineAnnotation<T> endValue(Double endValue) {
        this.endValue = endValue;
        return this;
    }

    public LineAnnotation<T> endValue(String endValue) {
        this.endValue = endValue;
        return this;
    }

    public LineAnnotation<T> borderColor(String borderColor) {
        this.borderColor = borderColor;
        return this;
    }

    public LineAnnotation<T> borderWidth(int borderWidth) {
        this.borderWidth = borderWidth;
        return this;
    }

    public LineAnnotation<T> borderDash(Integer ... borderDash) {
        this.borderDash = Arrays.asList(borderDash);
        return this;
    }

    public LineAnnotation<T> borderDashOffset(int borderDashOffset) {
        this.borderDashOffset = borderDashOffset;
        return this;
    }

    public LineLabel<T> label() {
        if (this.label == null) {
            this.label = new LineLabel(this);
            this.label.enabled(true);
        }
        return this.label;
    }

    @Override
    public LineAnnotation<T> getThis() {
        return this;
    }

    @Override
    public JsonObject buildJson() {
        JsonObject map = super.buildJson();
        if (this.vertical != null) {
            JUtils.putNotNull(map, "mode", this.vertical != false ? "vertical" : "horizontal");
        }
        JUtils.putNotNull(map, "scaleID", this.scaleID);
        JUtils.putNotNullObj(map, "value", this.value);
        JUtils.putNotNullObj(map, "endValue", this.endValue);
        JUtils.putNotNull(map, "borderColor", this.borderColor);
        JUtils.putNotNull(map, "borderWidth", this.borderWidth);
        JUtils.putNotNullIntList(map, "borderDash", this.borderDash);
        JUtils.putNotNull(map, "borderDashOffset", this.borderDashOffset);
        JUtils.putNotNull(map, "label", this.label);
        return map;
    }
}

