/*
 * Decompiled with CFR 0.152.
 */
package org.vaadin.addons.chartjs.options;

import elemental.json.Json;
import elemental.json.JsonObject;
import java.io.Serializable;
import org.vaadin.addons.chartjs.options.zoom.XYMode;
import org.vaadin.addons.chartjs.options.zoom.ZoomRange;
import org.vaadin.addons.chartjs.utils.And;
import org.vaadin.addons.chartjs.utils.JUtils;
import org.vaadin.addons.chartjs.utils.JsonBuilder;

public class Zoom<T>
extends And<T>
implements JsonBuilder,
Serializable {
    private boolean enabled = true;
    private boolean drag;
    private Double sensitivity;
    private XYMode mode;
    private ZoomRange<T> rangeMin;
    private ZoomRange<T> rangeMax;

    public Zoom(T parent) {
        super(parent);
    }

    public Zoom<T> enabled(boolean enabled) {
        this.enabled = enabled;
        return this;
    }

    public Zoom<T> drag(boolean drag) {
        this.drag = drag;
        return this;
    }

    public Zoom<T> sensitivity(double sensitivity) {
        this.sensitivity = sensitivity;
        return this;
    }

    public Zoom<T> mode(XYMode mode) {
        this.mode = mode;
        return this;
    }

    public ZoomRange<T> rangeMin() {
        if (this.rangeMin == null) {
            this.rangeMin = new ZoomRange(this);
        }
        return this.rangeMin;
    }

    public ZoomRange<T> rangeMax() {
        if (this.rangeMax == null) {
            this.rangeMax = new ZoomRange(this);
        }
        return this.rangeMax;
    }

    @Override
    public JsonObject buildJson() {
        JsonObject map = Json.createObject();
        JUtils.putNotNull(map, "enabled", this.enabled);
        JUtils.putNotNull(map, "drag", this.drag);
        JUtils.putNotNull(map, "sensitivity", this.sensitivity);
        if (this.mode != null) {
            JUtils.putNotNull(map, "mode", this.mode.name().toLowerCase());
        }
        JUtils.putNotNull(map, "rangeMin", this.rangeMin);
        JUtils.putNotNull(map, "rangeMax", this.rangeMax);
        return map;
    }
}

