/*
 * Decompiled with CFR 0.152.
 */
package com.anfcorp.stores.integration.writer;

import com.anfcorp.stores.integration.Context;
import com.anfcorp.stores.integration.IWriter;
import com.anfcorp.stores.integration.WriterException;
import java.io.IOException;
import java.util.HashMap;
import java.util.Map;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.jumpmind.symmetric.ISymmetricEngine;
import org.jumpmind.symmetric.StandaloneSymmetricEngine;
import org.jumpmind.symmetric.service.IDataLoaderService;
import org.jumpmind.symmetric.util.AppUtils;
import org.springframework.transaction.annotation.Transactional;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SymmetricDSWriter
implements IWriter<String> {
    static final Log logger = LogFactory.getLog(SymmetricDSWriter.class);
    StringBuilder buffer;
    private ISymmetricEngine symmetricEngine;
    private String configFileReference;
    private String nodeId = "setme";
    private static Map<String, ISymmetricEngine> symmetricEngines = new HashMap<String, ISymmetricEngine>();

    @Override
    public void write(String data) {
        this.buffer.append(data.trim());
        this.buffer.append("\n");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public void init() {
        this.symmetricEngine = symmetricEngines.get(this.configFileReference);
        if (this.symmetricEngine != null) return;
        Class<SymmetricDSWriter> clazz = SymmetricDSWriter.class;
        synchronized (SymmetricDSWriter.class) {
            this.symmetricEngine = new StandaloneSymmetricEngine(this.configFileReference);
            symmetricEngines.put(this.configFileReference, this.symmetricEngine);
            // ** MonitorExit[var1_1] (shouldn't be in output)
            return;
        }
    }

    @Override
    @Transactional
    public void close() {
        try {
            if (this.buffer != null) {
                this.buffer.append("commit\n");
                if (logger.isDebugEnabled()) {
                    logger.debug((Object)("\n--- SymmetricDS CSV --->\n" + this.buffer + "\n<--- SymmetricDS CSV ---"));
                }
                IDataLoaderService dataLoaderService = (IDataLoaderService)AppUtils.find((String)"dataLoaderService", (ISymmetricEngine)this.symmetricEngine);
                dataLoaderService.loadDataBatch(this.buffer.toString());
            } else {
                logger.error((Object)"Unexpected condition.  Closing writer without having buffer data.");
            }
        }
        catch (IOException ex) {
            throw new WriterException(ex);
        }
    }

    @Override
    public void open(Context context) {
        this.buffer = new StringBuilder();
        this.buffer.append("nodeid,");
        this.buffer.append(this.nodeId);
        this.buffer.append("\n");
        this.buffer.append("batch,1\n");
    }

    public void setNodeId(String nodeId) {
        this.nodeId = nodeId;
    }

    public void setConfigFileReference(String configFileReference) {
        this.configFileReference = configFileReference;
    }
}

