/*
 * Decompiled with CFR 0.152.
 */
package com.anfcorp.stores.integration.writer;

import com.anfcorp.stores.integration.Context;
import com.anfcorp.stores.integration.IWriter;
import java.util.List;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class CompoundWriter
implements IWriter<Object> {
    static final Log logger = LogFactory.getLog(CompoundWriter.class);
    List<IWriter<Object>> writers;

    @Override
    public void write(Object data) {
        if (this.writers != null) {
            for (IWriter<Object> w : this.writers) {
                w.write(data);
            }
        }
    }

    @Override
    public void close() {
        if (this.writers != null) {
            for (IWriter<Object> w : this.writers) {
                try {
                    w.close();
                }
                catch (Exception e) {
                    logger.error((Object)e, (Throwable)e);
                }
            }
        }
    }

    @Override
    public void open(Context context) {
        if (this.writers != null) {
            for (IWriter<Object> w : this.writers) {
                w.open(context);
            }
        }
    }

    public void setWriters(List<IWriter<Object>> writers) {
        this.writers = writers;
    }
}

