/*
 * Decompiled with CFR 0.152.
 */
package com.anfcorp.stores.integration.transform;

import com.anfcorp.stores.integration.Context;
import com.anfcorp.stores.integration.ITransform;
import com.anfcorp.stores.integration.TransformException;
import java.text.ParseException;
import java.util.Date;
import java.util.Map;
import org.apache.commons.lang.StringUtils;
import org.apache.commons.lang.time.DateUtils;
import org.jdom.Element;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class AbstractXmlToJdbcMapTransform
implements ITransform<Element, Map<String, Object>> {
    public static final String[] TIMESTAMP_PATTERNS = new String[]{"yyyy-MM-dd HH:mm:ss", "yyyy-MM-dd'T'HH:mm:ss.SSSSSSZ", "yyyy-MM-dd HH:mm:ss.S", "yyyy-MM-dd"};
    private String parentXmlTag;

    @Override
    public boolean isTransformable(Object data) {
        return data instanceof Element;
    }

    @Override
    public void reset() {
    }

    @Override
    public Map<String, Object> transform(Context context, Element element) {
        String name = element.getName();
        if (this.parentXmlTag.equals(name)) {
            return this.mapXml(context, element);
        }
        throw new IllegalStateException("The XML element " + name + " did not match the expected XML element of " + this.parentXmlTag);
    }

    protected abstract Map<String, Object> mapXml(Context var1, Element var2);

    public void setParentXmlTag(String parentXmlTag) {
        this.parentXmlTag = parentXmlTag;
    }

    protected Date parseDate(String date, String time) {
        StringBuilder b = new StringBuilder(date);
        b.append(" ");
        b.append(time);
        if (!StringUtils.isBlank((String)date) && !StringUtils.isBlank((String)time)) {
            try {
                return DateUtils.parseDate((String)b.toString(), (String[])TIMESTAMP_PATTERNS);
            }
            catch (ParseException e) {
                throw new TransformException("Could not parse the date " + b);
            }
        }
        return null;
    }

    protected String extractText(String elementname, Element element) {
        Element child = element.getChild(elementname);
        if (child != null) {
            return child.getValue();
        }
        return null;
    }

    protected String extractDbBoolean(String elementname, Element element) {
        String value;
        Element child = element.getChild(elementname);
        if (child != null && !StringUtils.isBlank((String)(value = child.getValue())) && (value.equals("Y") || value.equals("1"))) {
            return "1";
        }
        return "0";
    }
}

