/*
 * Decompiled with CFR 0.152.
 */
package com.anfcorp.stores.integration.common.events.handler;

import com.anfcorp.stores.integration.common.events.dao.EventLogVO;
import com.anfcorp.stores.integration.common.events.dao.EventLoggerDao;
import com.anfcorp.stores.integration.common.events.util.EventTypeEnum;
import org.apache.log4j.Logger;
import org.springframework.beans.BeansException;
import org.springframework.context.ApplicationContext;
import org.springframework.context.ApplicationContextAware;

public class EventLogHandler
implements ApplicationContextAware {
    private static Logger logger = Logger.getLogger(EventLogHandler.class);
    private static EventLoggerDao eventLogger;
    private static ApplicationContext ctx;

    public static void logInfo(String messageType, String jmsMessage) {
        try {
            EventLogHandler.log(messageType, jmsMessage, EventTypeEnum.INFO);
        }
        catch (Throwable t) {
            logger.error((Object)"Unable to insert the event to ANF_PS_EVENT_LOG table. ", t);
            throw new RuntimeException(t);
        }
    }

    public static void logError(String messageType, String jmsMessage) {
        try {
            EventLogHandler.log(messageType, jmsMessage, EventTypeEnum.ERROR);
        }
        catch (Throwable t) {
            logger.error((Object)"Unable to insert the event to ANF_PS_EVENT_LOG table. ", t);
        }
    }

    public static void logDebug(String messageType, String jmsMessage) {
        try {
            EventLogHandler.log(messageType, jmsMessage, EventTypeEnum.DEBUG);
        }
        catch (Throwable t) {
            logger.error((Object)"Unable to insert the event to ANF_PS_EVENT_LOG table. ", t);
        }
    }

    private static void log(String messageType, String jmsMessage, EventTypeEnum en) {
        try {
            EventLogVO eventLogVo = EventLogHandler.buildValueObject(messageType, jmsMessage, en.toString());
            EventLogHandler.getEventLogger();
            if (eventLogger != null) {
                eventLogger.insert(eventLogVo);
            }
        }
        catch (Throwable t) {
            logger.error((Object)"Unable to insert the event to ANF_PS_EVENT_LOG table. ", t);
        }
    }

    private static EventLogVO buildValueObject(String messageType, String jmsMessage, String eventType) {
        EventLogVO eventLogVo = new EventLogVO();
        eventLogVo.setEventType(eventType);
        eventLogVo.setMessageType(messageType);
        eventLogVo.setMessage(jmsMessage);
        return eventLogVo;
    }

    public static EventLoggerDao getEventLogger() {
        if (ctx != null && eventLogger == null) {
            eventLogger = (EventLoggerDao)ctx.getBean("eventLoggerDao");
        }
        return eventLogger;
    }

    public void setApplicationContext(ApplicationContext applicationContext) throws BeansException {
        ctx = applicationContext;
    }
}

