/*
 * Decompiled with CFR 0.152.
 */
package com.anfcorp.stores.integration.common.events.dao;

import com.anfcorp.stores.integration.common.events.dao.EventLogVO;
import com.anfcorp.stores.integration.common.events.dao.EventLoggerDao;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Timestamp;
import java.util.Date;
import org.springframework.dao.DataAccessException;
import org.springframework.jdbc.core.PreparedStatementCallback;
import org.springframework.jdbc.core.PreparedStatementCreator;
import org.springframework.jdbc.core.support.JdbcDaoSupport;

public class EventLoggerDaoImpl
extends JdbcDaoSupport
implements EventLoggerDao {
    public void insert(final EventLogVO eventVO) throws DataAccessException {
        this.getJdbcTemplate().execute(new PreparedStatementCreator(){

            public PreparedStatement createPreparedStatement(Connection conn) throws SQLException {
                PreparedStatement ps = conn.prepareStatement("INSERT INTO ANF_PS_EVENT_LOG (EVENT_TYPE, JMS_MESSAGE, MESSAGE_TYPE, CREATE_TMS) VALUES (?,?,?,?)");
                return ps;
            }
        }, new PreparedStatementCallback(){

            public Object doInPreparedStatement(PreparedStatement ps) throws SQLException, DataAccessException {
                ps.setString(1, eventVO.getEventType());
                ps.setString(2, eventVO.getMessage());
                ps.setString(3, eventVO.getMessageType());
                ps.setTimestamp(4, new Timestamp(new Date().getTime()));
                boolean hasResult = ps.execute();
                ResultSet rtn = null;
                if (hasResult) {
                    rtn = ps.getResultSet();
                }
                return rtn;
            }
        });
    }
}

